<?php

if (!function_exists("cleanString")) {

	function cleanString($string, $separator = '-') {
		$accents = array(
			'Š' => 'S',
			'š' => 's',
			'Ð' => 'Dj',
			'Ž' => 'Z',
			'ž' => 'z',
			'À' => 'A',
			'Á' => 'A',
			'Â' => 'A',
			'Ã' => 'A',
			'Ä' => 'A',
			'Å' => 'A',
			'Æ' => 'A',
			'Ç' => 'C',
			'È' => 'E',
			'É' => 'E',
			'Ê' => 'E',
			'Ë' => 'E',
			'Ì' => 'I',
			'Í' => 'I',
			'Î' => 'I',
			'Ï' => 'I',
			'Ñ' => 'N',
			'Ò' => 'O',
			'Ó' => 'O',
			'Ô' => 'O',
			'Õ' => 'O',
			'Ö' => 'O',
			'Ø' => 'O',
			'Ù' => 'U',
			'Ú' => 'U',
			'Û' => 'U',
			'Ü' => 'U',
			'Ý' => 'Y',
			'Þ' => 'B',
			'ß' => 'Ss',
			'à' => 'a',
			'á' => 'a',
			'â' => 'a',
			'ã' => 'a',
			'ä' => 'a',
			'å' => 'a',
			'æ' => 'a',
			'ç' => 'c',
			'è' => 'e',
			'é' => 'e',
			'ê' => 'e',
			'ë' => 'e',
			'ì' => 'i',
			'í' => 'i',
			'î' => 'i',
			'ï' => 'i',
			'ð' => 'o',
			'ñ' => 'n',
			'ò' => 'o',
			'ó' => 'o',
			'ô' => 'o',
			'õ' => 'o',
			'ö' => 'o',
			'ø' => 'o',
			'ù' => 'u',
			'ú' => 'u',
			'û' => 'u',
			'ý' => 'y',
			'ý' => 'y',
			'þ' => 'b',
			'ÿ' => 'y',
			'ƒ' => 'f',
			'Ä' => 'Ae',
			'ä' => 'ae',
			'Ö' => 'Oe',
			'ö' => 'oe',
			'Ü' => 'Ue',
			'ü' => 'ue',
			'ß' => 'ss'
		);
		$string = strtr($string, $accents);
		$string = strtolower($string);
		$string = preg_replace('/[^a-zA-Z0-9\s]/', '', $string);
		$string = preg_replace('{ +}', ' ', $string);
		$string = trim($string);
		$string = str_replace(' ', $separator, $string);

		return $string;
	}

}

if (isset($_GET ["blog_admin"])) {
	if ($_GET ["blog_admin"] == "update" or $_GET ["blog_admin"] == "submit") {
		if (empty($_POST ["seo_shortname"]) and ! empty($_POST ["title"])) {
			$_POST ["seo_shortname"] = cleanString($_POST ["title"]);
		}
	}
}
?>